#define USEFOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye : register (c8);
float4 fogData : register (c9);

#if OMNI == 1

float4 omniPosRad[12]   : register (c72);
float4 omniRGBDelta[12] : register (c84);

#elif SPOT == 1

float4 spotPosRad[4]    : register (c72);
float4 spotRGBDelta[4]  : register (c80);
float4 spotDirCone[4]   : register (c88);

#endif

#if NUMTEX == 1

  struct VS_OUTPUT
  {
    float4 Pos   : POSITION;
    float4 Diff  : COLOR0;
    float4 Omni  : COLOR1;
  #ifdef USEFOG
    float Fog    : FOG;
  #endif   
    float2 Tex0  : TEXCOORD0;
    float4 Norm  : TEXCOORD1;
  };
   
#elif NUMTEX == 2

  struct VS_OUTPUT
  {
    float4 Pos   : POSITION;
    float4 Diff  : COLOR0;
    float4 Omni  : COLOR1;
  #ifdef USEFOG
    float Fog    : FOG;
  #endif   
    float2 Tex0  : TEXCOORD0;
    float2 Tex1  : TEXCOORD1;
    float4 Norm  : TEXCOORD2;
  };
   
#elif NUMTEX == 3 

  struct VS_OUTPUT
  {
    float4 Pos   : POSITION;
    float4 Diff  : COLOR0;
    float4 Omni  : COLOR1;
  #ifdef USEFOG
    float Fog    : FOG;
  #endif   
    float2 Tex0  : TEXCOORD0;
    float2 Tex1  : TEXCOORD1;
    float2 Tex2  : TEXCOORD2;
    float4 Norm  : TEXCOORD3;
  };
  
#elif NUMTEX == 4 

  struct VS_OUTPUT
  {
    float4 Pos   : POSITION;
  #if OMNI == 1 || SPOT == 1  
    float4 Omni  : COLOR0;
  #else  
    float4 Diff  : COLOR0;
  #endif  
    float4 Norm  : COLOR1;
  #ifdef USEFOG
    float Fog    : FOG;
  #endif   
    float2 Tex0  : TEXCOORD0;
    float2 Tex1  : TEXCOORD1;
    float2 Tex2  : TEXCOORD2;
    float2 Tex3  : TEXCOORD3;
  };

#endif

#if OMNI == 1

 #if NUMTEX == 1
  VS_OUTPUT vs11_blinnDiffuseOmniT0  (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_blinnDiffuseOmniT0T1 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1)
 #elif NUMTEX == 3
  VS_OUTPUT vs11_blinnDiffuseOmniT0T1T2 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2)
 #elif NUMTEX == 4
  VS_OUTPUT vs11_blinnDiffuseOmniT0T1T2T3 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2, float2 inTex3 : TEXCOORD3)
 #endif
  
#elif SPOT == 1

 #if NUMTEX == 1
  VS_OUTPUT vs11_blinnDiffuseSpotT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_blinnDiffuseSpotT0T1 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1)
 #elif NUMTEX == 3
  VS_OUTPUT vs11_blinnDiffuseSpotT0T1T2 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2)
 #elif NUMTEX == 4
  VS_OUTPUT vs11_blinnDiffuseSpotT0T1T2T3 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2, float2 inTex3 : TEXCOORD3)
 #endif
  
#else

 #if NUMTEX == 1
  VS_OUTPUT vs11_blinnDiffuseT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_blinnDiffuseT0T1 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1)
 #elif NUMTEX == 3
  VS_OUTPUT vs11_blinnDiffuseT0T1T2 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2)
 #elif NUMTEX == 4
  VS_OUTPUT vs11_blinnDiffuseT0T1T2T3 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2, float2 inTex3 : TEXCOORD3)
 #endif
  
#endif
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space:
  Out.Pos = mul (viewProjMatrix, inPos);
  float3 worldPos = mul (worldMatrix, inPos);

  // Transform vertex normal into world space:
  float4 worldNorm = mul (worldMatrix, inNorm.xyz);
  Out.Norm = (worldNorm * 0.5) + 0.5;

#ifdef USEFOG
  // compute fog
  float3 eyeVec = worldPos + worldEye;
  Out.Fog.x = (fogData[1] - (length (eyeVec.xyz) * fogData[0]));
#endif   
  
#if OMNI == 1
  // Compute omnilights
  Out.Omni = (0,0,0,0);
  Out.Omni.a = inColor.a;
  
  for (int i=0; i<6; i++)
  {
    float intens;
    float3 omniToVert = omniPosRad[i].xyz - worldPos.xyz;
    float mag = dot (omniToVert.xyz, omniToVert.xyz);
    // check if vert in range
    if ( mag < omniPosRad[i].w) // using square distances
      if ((intens = dot (worldNorm, normalize (omniToVert))) > 0) // check backface
        Out.Omni.rgb += (sqrt(intens) * omniRGBDelta[i].rgb * (1.0F - (sqrt(mag) * omniRGBDelta[i].w)));
  }
  #if NUMTEX < 4
   Out.Diff = inColor;
  #endif 
  
#elif SPOT == 1

  // Compute spotlights
  float4 spotColor = (0,0,0,0);
  //for (int i=0; i<numActive.y; i++)
  for (int i=0; i<4; i++)
  {
    // check backface
    if (dot (worldNorm, spotDirCone[i].xyz) <= 0)
    {
      float3 spotToVert = worldPos.xyz - spotPosRad[i].xyz;
      float mag = dot (spotToVert.xyz, spotToVert.xyz);
      // check if vert in range
      if (mag < spotPosRad[i].w) // using square distances
      {
        // check if vert in cone
        mag = dot (normalize (spotToVert.xyz), spotDirCone[i].xyz);
        if (mag > spotDirCone[i].w)
        {
          float intensity = (1.0F - ( sqrt (mag) * spotRGBDelta[i].w));
          spotColor.rgb += (spotRGBDelta[i].rgb * intensity);
        }  
      }
    }
  }
  Out.Omni = spotColor;
  #if NUMTEX < 4
   Out.Diff = inColor;
  #endif 
  
#elif NUMTEX < 4
  Out.Omni = 0;
  Out.Diff = inColor;
#else
  Out.Diff = inColor;
#endif  

  Out.Tex0 = inTex0;
#if NUMTEX > 1
  Out.Tex1 = inTex1;
#endif  
#if NUMTEX > 2
  Out.Tex2 = inTex2;
#endif  
#if NUMTEX > 3
  Out.Tex3 = inTex3;
#endif  

  return (Out);
}



